/**************************************************************************************
Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.
***************************************************************************************
$Id: EipObject_Identity_Public.h 51162 2015-01-29 10:21:28Z kai $:

Description:
  Public definitions of the identity object

Changes:
 Date          Description
 -----------------------------------------------------------------------------------
 2010-11-01    created
**************************************************************************************/

#ifndef __EIP_OBJECT_IDENTITIY_PUBLIC_H
  #define __EIP_OBJECT_IDENTITIY_PUBLIC_H

/*#####################################################################################*/
/*#####################################################################################*/
/* Eip Object public, constants */



/*#####################################################################################*/
/*#####################################################################################*/
/* Eip Object public, types */


/*#####################################################################################*/
/*#####################################################################################*/
/* Eip Object public, packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(EIP_OBJECT_PUBLIC)
#endif

/*#####################################################################################*/
/*#####################################################################################*/

/*! \addtogroup EIP_OBJECT_ID_SETDEVICEINFO_REQ_Content
 * \{*/
#define EIP_ID_MAX_PRODUKTNAME_LEN  32
/* \} */
/*#####################################################################################*/
/*#####################################################################################*/

/*! \defgroup EIP_OBJECT_ID_SETDEVICEINFO_REQ_Content Command related contents
 *  \ingroup EIP_OBJECT_ID_SETDEVICEINFO_REQ
 * \{ */

typedef struct EIP_OBJECT_ID_SETDEVICEINFO_REQ_Ttag
{
  TLR_UINT32 ulVendId;        /*!< CIP vendor identification \n

                                     \valueRange
                                     1...65535 \n
                                     Default: 283 (Hilscher GmbH)

                                     \description
                                     This is an identification number for
                                     the manufacturer of an EtherNet/IP device.
                                     Vendor IDs are managed by ODVA.
                                     The value zero is not valid */

  TLR_UINT32 ulProductType;   /*!< CIP device type \n

                                     \valueRange
                                     Publicly defined: 0x00 - 0x64    \n
                                     Vendor specific: 0x64 - 0xC7     \n
                                     Reserved by CIP: 0xC8 - 0xFF     \n
                                     Publicly defined: 0x100 - 0x2FF  \n
                                     Vendor specific: 0x300 - 0x4FF   \n
                                     Reserved by CIP: 0x500 - 0xFFFF  \n\n
                                     Default: 0x0C (Communication Device)

                                     \description
                                     The list of device types is managed by ODVA.
                                     It is used to identify the device profile that a
                                     particular product is using. Device profiles
                                     define minimum requirements a device must
                                     implement as well as common options. */

  TLR_UINT32 ulProductCode;     /*!< Product code \n

                                     \valueRange
                                     1...65535

                                     \description
                                     The vendor assigned Product Code identifies a particular product within a device type. Each
                                     vendor assigns this code to each of its products. The Product Code typically maps to one or
                                     more catalog/model numbers. Products shall have different codes if their configuration and/or
                                     runtime options are different. Such devices present a different logical view to the network. On
                                     the other hand for example, two products that are the same except for their color or mounting
                                     feet are the same logically and may share the same product code.
                                     The value zero is not valid. */
  TLR_UINT32 ulMajRev;          /*!< Major revision \n

                                     \valueRange
                                     1...127 */

  TLR_UINT32 ulMinRev;          /*!< Minor revision \n

                                     \valueRange
                                     1...255 */

  TLR_UINT32 ulSerialNumber;    /*!< Serial number \n

                                     \valueRange
                                     0x00000000... 0xFFFFFFFF

                                     \description
                                     This attribute is a number used in conjunction with the Vendor ID to form a unique identifier
                                     for each device on any CIP network. Each vendor is responsible for guaranteeing the
                                     uniqueness of the serial number across all of its devices. \n
                                     Usually, this number will be set automatically by the firmware,
                                     if a security memory is available. */

  TLR_UINT8  abProductName[EIP_ID_MAX_PRODUKTNAME_LEN]; /*!< Device name with maximum name length of \ref EIP_ID_MAX_PRODUKTNAME_LEN\n

                                                             \description
                                                             This text string should represent a short description of the product/product family represented
                                                             by the product code. The same product code may have a variety of product name
                                                             strings.\n\n
                                                             The first byte indicates the name length, byte
                                                             2-31 contain the actual characters of the device name.*/
}EIP_OBJECT_ID_SETDEVICEINFO_REQ_T;

typedef struct EIP_OBJECT_ID_PACKET_SETDEVICEINFO_REQ_Ttag
{
  TLR_PACKET_HEADER_T               tHead;
  EIP_OBJECT_ID_SETDEVICEINFO_REQ_T tData;
}EIP_OBJECT_ID_PACKET_SETDEVICEINFO_REQ_T;

#define EIP_OBJECT_ID_SETDEVICEINFO_REQ_SIZE (sizeof(EIP_OBJECT_ID_SETDEVICEINFO_REQ_T))

typedef struct EIP_OBJECT_ID_PACKET_SETDEVICEINFO_CNF_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
}EIP_OBJECT_ID_PACKET_SETDEVICEINFO_CNF_T;

#define EIP_OBJECT_ID_SETDEVICEINFO_CNF_SIZE 0

/* \} */
/*#####################################################################################*/
/*#####################################################################################*/

typedef __PACKED_PRE struct EIP_OBJECT_IDENTITYINFO_Ttag
{
    TLR_UINT16  usVendor;
    TLR_UINT16  usProductType;
    TLR_UINT16  usProductCode;
    TLR_UINT8   bMajorRevision;
    TLR_UINT8   bMinorRevision;
    TLR_UINT16  usStatus;
    TLR_UINT32  ulSerialNumber;
    TLR_UINT8   abProductName[EIP_ID_MAX_PRODUKTNAME_LEN];
    TLR_UINT8   bState;
}__PACKED_POST  EIP_OBJECT_IDENTITYINFO_T;

typedef __PACKED_PRE struct EIP_OBJECT_ID_PACKET_GETINFO_REQ_Ttag
{
  TLR_PACKET_HEADER_T  tHead;
}__PACKED_POST EIP_OBJECT_ID_PACKET_GETINFO_REQ_T ;

typedef __PACKED_PRE struct EIP_OBJECT_ID_GETINFO_CNF_Ttag
{
  EIP_OBJECT_IDENTITYINFO_T *ptIdInfo;
} __PACKED_POST EIP_OBJECT_ID_GETINFO_CNF_T;

typedef __PACKED_PRE struct EIP_OBJECT_ID_PACKET_GETINFO_CNF_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
  EIP_OBJECT_ID_GETINFO_CNF_T tData;
} __PACKED_POST EIP_OBJECT_ID_PACKET_GETINFO_CNF_T;

/*#####################################################################################*/
/*#####################################################################################*/

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(EIP_OBJECT_PUBLIC)
#endif



/***************************************************************************************/
/* Eip Object public, prototypes */



/***************************************************************************************/
#endif

